import pandas as pd
import numpy as np
import pickle
from decision_company import read_csv_file, iterate_rows, access_dataframe_loc, update_dataframe_loc

atp_tennis = read_csv_file('atp_tennis.csv')

for index, row in iterate_rows(head_to_head_matches):
    winner = row['Winner']
    loser = row['Player_1'] if row['Player_1'] != winner else row['Player_2']
    current_value = access_dataframe_loc(head_to_head_matrix, winner, loser)
    update_dataframe_loc(head_to_head_matrix, winner, loser, current_value + 1)

print(head_to_head_matrix)
pickle.dump(head_to_head_matrix,open("./ref_result/head_to_head_matrix.pkl","wb"))